package gov.va.med.mhv.phr.appointments.model;

import org.displaytag.decorator.TableDecorator;

/**
 * Defines the order in which Appointment view summaries are ordered.
 * @author Rob Proper
 */
public class AppointmentsRowSorter extends MultiPropertyRowSorter {

    private static final SortOrder[] SORT_ORDER = {
        new SortOrder("appointmentDate", false),
        new SortOrder("appointmentStatus", true),
        new SortOrder("clinicName", true),
        new SortOrder("location", true)
    };

    public AppointmentsRowSorter(String propertyName, TableDecorator tableDecorator,
        boolean isAscending)
    {
        super(propertyName, tableDecorator, isAscending);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.model.MultiplePropertySorter#getSortOrder()
     */
    @Override
    protected SortOrder[] getSortOrder()
    {
        return SORT_ORDER;
    }

}
